import React, { useEffect, useRef, useState } from "react";
import {
  Accordion,
  AccordionHeader,
  AccordionBody,
} from "@material-tailwind/react";
import MapSVG from "../../assets/img/neighbourhood/map.svg";
import Dining from "../../assets/img/neighbourhood/dining.svg";
import Recreation from "../../assets/img/neighbourhood/recreation.svg";
import Schools from "../../assets/img/neighbourhood/schools.svg";
import Shopping from "../../assets/img/neighbourhood/shopping.svg";
import WhiteBar from "../../assets/img/neighbourhood/whitebar.svg";
import North from "../../assets/img/neighbourhood/northicon.svg";
import PurpleDot from "../../assets/img/neighbourhood/purple-dot.svg";
import OrangeDot from "../../assets/img/neighbourhood/orange-dot.svg";
import GreenDot from "../../assets/img/neighbourhood/green-dot.svg";
import BlueDot from "../../assets/img/neighbourhood/blue-dot.svg";
import { locations } from "./markers";
import "./map.css";

const Map = () => {  
	const [open, setOpen] = React.useState(1);
	const handleOpen = (value) => setOpen(open === value ? 0 : value);
	const [category, setCategory] = useState("shopping");
	const shoppingDot1 = useRef(null);
	function handleMapDotOver(cat, index) {
		var els = document.getElementsByClassName('map-dots active');
		while (els[0]) {
			els[0].classList.remove('active')
		}
		document.getElementById(cat+'-dot-'+index).classList.toggle('over');	
	}
	function handleMapDotClick(cat, index) {
		//document.getElementsByClassName('map-dots').classList.remove('active');
		var els = document.getElementsByClassName('map-dots active');
		while (els[0]) {
			els[0].classList.remove('active')
		}
		document.getElementById(cat+'-dot-'+index).classList.add('active');		
	}
	useEffect(() => {
		return () => {
		};
	}, []);	
  return (
	<div className="relative">
		<div className="relative overflow-x-hidden">
			<div className="float-right relative w-[190vw] lg:w-full">
				<img src={MapSVG} className="relative max-w-[none] w-full"></img>
				<div className="absolute top-0 bottom-0 left-0 right-0">
					<svg 
						  xmlns="http://www.w3.org/2000/svg"
						  xmlSpace="preserve"
						  x="0px" 
						  y="0px"
						  viewBox="0 0 1328.5 894.2"
						  style={{
						  shapeRendering: "geometricPrecision",
						  textRendering: "geometricPrecision",
						  imageRendering: "optimizeQuality",
						  fillRule: "evenodd",
						  clipRule: "evenodd",
						  width: "100%",
						}} 
					  >
						<defs>
						  <style>
							{".st0-shopping{fill-rule:evenodd;clip-rule:evenodd;fill:#A8518A;}.st0-dining{fill-rule:evenodd;clip-rule:evenodd;fill:#F58634;}.st0-recreation{fill-rule:evenodd;clip-rule:evenodd;fill:#00A859;}.st0-school{fill-rule:evenodd;clip-rule:evenodd;fill:#0098DA;}.st1{fill:#FEFEFE;}.st2{fill:none;}"}
						  </style>
						</defs>
						<g id="shopping" className={`${category === "shopping" || category === "all" ? "visible" : "invisible"}`}>
							<g>
								<g className="cursor-pointer" id="shopping-legend-1" onMouseOver={() => {
								  handleMapDotOver("shopping", 1);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 1);
								}}>
									<circle className="st0-shopping" cx="796" cy="518.2" r="7.6"/>
									
									<text className="st1 text-[12px]" x="794" y="522.5">1</text>
								</g>
								<g className="cursor-pointer" id="shopping-legend-2" onMouseOver={() => {
								  handleMapDotOver("shopping", 2);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 2);
								}}>
									<circle className="st0-shopping" cx="870.2" cy="663.7" r="7.6"/>
									<text className="st1 text-[12px]" x="866.7" y="667.75">2</text>
								</g>
								<g className="cursor-pointer" id="shopping-legend-3" onMouseOver={() => {
								  handleMapDotOver("shopping", 3);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 3);
								}}>
									<circle className="st0-shopping" cx="1086.7" cy="280.2" r="7.6"/>
									<text className="st1 text-[12px]" x="1083.2" y="284.4">3</text>
								</g>
								<g className="cursor-pointer" id="shopping-legend-4" onMouseOver={() => {
								  handleMapDotOver("shopping", 4);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 4);
								}}>
									<circle className="st0-shopping" cx="891.2" cy="843.1" r="7.6"/>
									<text className="st1 text-[12px]" x="887.7" y="847.4">4</text>
								</g>
								<g className="cursor-pointer" id="shopping-legend-5" onMouseOver={() => {
								  handleMapDotOver("shopping", 5);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 5);
								}}>
									<circle className="st0-shopping" cx="1163.8" cy="645.7" r="7.6"/>
									<text className="st1 text-[12px]" x="1160" y="650">5</text>
								</g>
								<g className="cursor-pointer" id="shopping-legend-6" onMouseOver={() => {
								  handleMapDotOver("shopping", 6);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 6);
								}}>
									<circle className="st0-shopping" cx="1146.1" cy="648.7" r="7.6"/>
									<text className="st1 text-[12px]" x="1142.5" y="653">6</text>
								</g>
								<g className="cursor-pointer" id="shopping-legend-7" onMouseOver={() => {
								  handleMapDotOver("shopping", 7);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 7);
								}}>
									<circle className="st0-shopping" cx="704.8" cy="367.4" r="7.6"/>
									<text className="st1 text-[12px]" x="701.8" y="372">7</text>
								</g>
								<g className="cursor-pointer" id="shopping-legend-8" onMouseOver={() => {
								  handleMapDotOver("shopping", 8);
								}} onMouseOut={() => {
								  handleMapDotOver("shopping", 8);
								}}>
									<circle className="st0-shopping" cx="1048.4" cy="859.7" r="7.6"/>
									<text className="st1 text-[12px]" x="1045" y="863.7">8</text>
								</g>
							</g>
						</g>

						<g id="dining" className={`${category === "dining" || category === "all" ? "visible" : "invisible"}`}>
							<g className="cursor-pointer" id="dining-legend-1" onMouseOver={() => {
								  handleMapDotOver("dining", 1);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 1);
								}}>
								<circle className="st0-dining" cx="897.1" cy="603.9" r="7.6"/>
								<text className="st1 text-[12px]" x="895.1" y="607.9">1</text>
							</g>
							<g className="cursor-pointer" id="dining-legend-2" onMouseOver={() => {
								  handleMapDotOver("dining", 2);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 2);
								}}>
								<circle className="st0-dining" cx="897.1" cy="583.2" r="7.6"/>
								<text className="st1 text-[12px]" x="893.5" y="587.2">2</text>
							</g>
							<g className="cursor-pointer" id="dining-legend-3" onMouseOver={() => {
								  handleMapDotOver("dining", 3);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 3);
								}}>
								<circle className="st0-dining" cx="872" cy="597.2" r="7.6"/>
								<text className="st1 text-[12px]" x="868.5" y="601.4">3</text>
							</g>
							<g className="cursor-pointer" id="dining-legend-4" onMouseOver={() => {
								  handleMapDotOver("dining", 4);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 4);
								}}>
								<circle className="st0-dining" cx="872" cy="615.7" r="7.6"/>
								<text className="st1 text-[12px]" x="868" y="619.9">4</text>
							</g>
							<g className="cursor-pointer" id="dining-legend-5" onMouseOver={() => {
								  handleMapDotOver("dining", 5);
								}} onMouseOut={() => {
								  handleMapDotOver("dining", 5);
								}}>
								<circle className="st0-dining" cx="895.6" cy="689.8" r="7.6"/>
								<text className="st1 text-[12px]" x="891.6" y="693.8">5</text>
							</g>
							<g className="cursor-pointer" id="dining-legend-6" onMouseOver={() => {
							  handleMapDotOver("dining", 6);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 6);
							}}>
								<circle className="st0-dining" cx="812.9" cy="517.9" r="7.6"/>
								<text className="st1 text-[12px]" x="809.3" y="522">6</text>
							</g>
							<g className="cursor-pointer" id="dining-legend-7" onMouseOver={() => {
							  handleMapDotOver("dining", 7);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 7);
							}}>
								<circle className="st0-dining" cx="917.1" cy="689.8" r="7.6"/>
								<text className="st1 text-[12px]" x="914" y="694">7</text>
							</g>
							<g className="cursor-pointer" id="dining-legend-8" onMouseOver={() => {
							  handleMapDotOver("dining", 8);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 8);
							}}>
								<circle className="st0-dining" cx="715.5" cy="239.9" r="7.6"/>
								<text className="st1 text-[12px]" x="711.9" y="243.99">8</text>
							</g>
							<g className="cursor-pointer" id="dining-legend-9" onMouseOver={() => {
							  handleMapDotOver("dining", 9);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 9);
							}}>
								<circle className="st0-dining" cx="661.6" cy="256.1" r="7.6"/>
								<text className="st1 text-[12px]" x="657.6" y="260.07">9</text>
							</g>
							<g className="cursor-pointer" id="dining-legend-10" onMouseOver={() => {
							  handleMapDotOver("dining", 10);
							}} onMouseOut={() => {
							  handleMapDotOver("dining", 10);
							}}>
								<circle className="st0-dining" cx="940.6" cy="743.6" r="7.6"/>
								<text className="st1 text-[12px]" x="935.1" y="747.6">10</text>
							</g>
						</g>

						<g id="recreation" className={`${category === "recreation" || category === "all" ? "visible" : "invisible"}`}>
							<g>
								<g className="cursor-pointer" id="recreation-legend-1" onMouseOver={() => {
								  handleMapDotOver("recreation", 1);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 1);
								}}>
									<circle className="st0-recreation" cx="832.9" cy="492.9" r="7.6"/>
									<text className="st1 text-[12px]" x="830.8" y="496.9">1</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-2" onMouseOver={() => {
								  handleMapDotOver("recreation", 2);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 2);
								}}>
									<circle className="st0-recreation" cx="827.2" cy="575.3" r="7.6"/>
									<text className="st1 text-[12px]" x="823.7" y="579.08">2</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-3" onMouseOver={() => {
								  handleMapDotOver("recreation", 3);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 3);
								}}>
									<circle className="st0-recreation" cx="1021.9" cy="531" r="7.6"/>
									<text className="st1 text-[12px]" x="1018.3" y="535.1">3</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-4" onMouseOver={() => {
								  handleMapDotOver("recreation", 4);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 4);
								}}>
									<circle className="st0-recreation" cx="1021.2" cy="566" r="7.6"/>
									<text className="st1 text-[12px]" x="1017.4" y="570">4</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-5" onMouseOver={() => {
								  handleMapDotOver("recreation", 5);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 5);
								}}>
									<circle className="st0-recreation" cx="1182.9" cy="485.5" r="7.6"/>
									<text className="st1 text-[12px]" x="1179.2" y="489.5">5</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-6" onMouseOver={() => {
								  handleMapDotOver("recreation", 6);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 6);
								}}>
									<circle className="st0-recreation" cx="961" cy="182" r="7.6"/>
									<text className="st1 text-[12px]" x="957.3" y="186.07">6</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-7" onMouseOver={() => {
								  handleMapDotOver("recreation", 7);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 7);
								}}>
									<circle className="st0-recreation" cx="1189.1" cy="161.5" r="7.6"/>
									<text className="st1 text-[12px]" x="1185.8" y="165.9">7</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-8" onMouseOver={() => {
								  handleMapDotOver("recreation", 8);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 8);
								}}>
									<circle className="st0-recreation" cx="1023.1" cy="280.5" r="7.6"/>
									<text className="st1 text-[12px]" x="1019.5" y="284.1">8</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-9" onMouseOver={() => {
								  handleMapDotOver("recreation", 9);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 9);
								}}>
									<circle className="st0-recreation" cx="675.4" cy="547.3" r="7.6"/>
									<text className="st1 text-[12px]" x="671.5" y="551.2">9</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-10" onMouseOver={() => {
								  handleMapDotOver("recreation", 10);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 10);
								}}>
									<circle className="st0-recreation" cx="776" cy="685.6" r="7.6"/>
									<text className="st1 text-[12px]" x="770.5" y="689.6">10</text>
								</g>
								<g className="cursor-pointer" id="recreation-legend-11" onMouseOver={() => {
								  handleMapDotOver("recreation", 11);
								}} onMouseOut={() => {
								  handleMapDotOver("recreation", 11);
								}}>
									<circle className="st0-recreation" cx="711.8" cy="297.4" r="7.6"/>
									<text className="st1 text-[12px]" x="708" y="301.4">11</text>
								</g>
							</g>
						</g>

						<g id="schools" className={`transition-all duration-500 ${category === "schools" || category === "all" ? "visible" : "invisible"}`}>
							<g>
								<g className="cursor-pointer" id="schools-legend-1" onMouseOver={() => {
								  handleMapDotOver("schools", 1);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 1);
								}}>
									<circle className="st0-school" cx="755.8" cy="531.8" r="7.6"/>
									<polygon className="st1" points="757.1,536 757.1,527.6 756.2,527.6 754.6,528.9 754.6,529.9 756.2,528.5 756.2,536 				"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-2" onMouseOver={() => {
								  handleMapDotOver("schools", 2);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 2);
								}}>
									<circle className="st0-school" cx="751.7" cy="334.9" r="7.6"/>
									<path className="st1" d="M754,339.1v-0.8h-3.6l2.9-3.8c0.5-0.6,0.7-1,0.7-1.7c0-1.4-0.9-2.3-2.3-2.3c-1.4,0-2.3,1-2.3,2.3h0.9
										c0-1.1,0.7-1.5,1.5-1.5c0.9,0,1.5,0.6,1.5,1.5c0,0.5-0.2,0.8-0.5,1.2l-3.3,4.2v0.8H754z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-3" onMouseOver={() => {
								  handleMapDotOver("schools", 3);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 3);
								}}>
									<circle className="st0-school" cx="1037.2" cy="469" r="7.6"/>
									<path className="st1" d="M1039.6,470.9c0-1.1-0.4-1.7-1.3-2.1c0.8-0.3,1.1-1,1.1-1.9c0-1.4-0.9-2.3-2.3-2.3c-1.3,0-2.3,0.8-2.4,2.2
										h0.9c0.1-0.9,0.6-1.4,1.5-1.4c0.8,0,1.5,0.5,1.5,1.5c0,0.9-0.5,1.5-1.5,1.5h-0.2v0.7h0.2c1.1,0,1.7,0.6,1.7,1.6
										c0,1-0.7,1.6-1.6,1.6c-0.8,0-1.5-0.4-1.6-1.5h-0.9c0.1,1.5,1.1,2.2,2.5,2.2C1038.5,473.3,1039.6,472.5,1039.6,470.9z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-4" onMouseOver={() => {
								  handleMapDotOver("schools", 4);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 4);
								}}>
									<circle className="st0-school" cx="1042.8" cy="516.5" r="7.6"/>
									<polygon className="st1" points="1045.4,519.4 1045.4,518.6 1044.4,518.6 1044.4,516.2 1043.6,516.2 1043.6,518.6 1041.1,518.6 
										1044.2,512.3 1043.3,512.3 1040.2,518.6 1040.2,519.4 1043.6,519.4 1043.6,520.7 1044.4,520.7 1044.4,519.4 				"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-5" onMouseOver={() => {
								  handleMapDotOver("schools", 5);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 5);
								}}>
									<circle className="st0-school" cx="1230.4" cy="400.1" r="7.6"/>
									<path className="st1" d="M1232.7,401.5c0-0.8-0.1-1.6-0.7-2.3c-0.3-0.3-0.8-0.5-1.5-0.5c-0.7,0-1.2,0.2-1.5,0.6v-2.7h3.5v-0.8h-4.3
										v4.4h0.8c0.2-0.5,0.7-0.8,1.4-0.8c1.2,0,1.4,1,1.4,2c0,0.6,0,1.3-0.5,1.7c-0.2,0.2-0.6,0.4-1,0.4c-0.9,0-1.3-0.5-1.4-1.3h-0.9
										c0,0.6,0.2,1.1,0.6,1.5c0.4,0.4,1,0.6,1.7,0.6c0.7,0,1.3-0.2,1.7-0.6C1232.6,403.1,1232.7,402.3,1232.7,401.5z"/>
								</g>						
								<g className="cursor-pointer" id="schools-legend-6" onMouseOver={() => {
								  handleMapDotOver("schools", 6);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 6);
								}}>
									<circle className="st0-school" cx="926.9" cy="735.8" r="7.6"/>
									<path className="st1" d="M929.2,737.6c0-1.4-0.9-2.4-2.2-2.4c-0.3,0-0.6,0.1-0.9,0.2l1.9-3.8h-0.9l-2.1,4.2
										c-0.4,0.7-0.5,1.3-0.5,1.9c0,1.5,0.9,2.4,2.3,2.4C928.3,740.1,929.2,739,929.2,737.6z M928.4,737.6c0,1-0.6,1.7-1.5,1.7
										c-0.9,0-1.5-0.7-1.5-1.7c0-1,0.6-1.7,1.5-1.7C927.9,735.9,928.4,736.7,928.4,737.6z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-7" onMouseOver={() => {
								  handleMapDotOver("schools", 7);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 7);
								}}>
									<circle className="st0-school" cx="941.2" cy="629.5" r="7.6"/>
									<polygon className="st1" points="943.5,626 943.5,625.3 938.8,625.3 938.8,627.4 939.7,627.4 939.7,626 942.6,626 939.7,633.7 
										940.6,633.7 				"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-8" onMouseOver={() => {
								  handleMapDotOver("schools", 8);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 8);
								}}>
									<circle className="st0-school" cx="841" cy="689.8" r="7.6"/>
									<path className="st1" d="M843.5,691.7c0-1-0.5-1.6-1.3-2c0.7-0.4,1.1-1,1.1-1.9c0-1.3-1-2.3-2.3-2.3c-1.3,0-2.3,0.9-2.3,2.3
										c0,0.9,0.4,1.5,1.1,1.9c-0.7,0.4-1.3,1.1-1.3,2c0,1.4,1.1,2.4,2.5,2.4C842.4,694.1,843.5,693.1,843.5,691.7z M842.6,691.7
										c0,0.9-0.7,1.6-1.6,1.6c-0.9,0-1.6-0.7-1.6-1.6s0.7-1.6,1.6-1.6C841.9,690,842.6,690.7,842.6,691.7z M842.5,687.8
										c0,0.9-0.6,1.5-1.5,1.5c-0.9,0-1.5-0.6-1.5-1.5c0-0.9,0.6-1.5,1.5-1.5C841.9,686.3,842.5,686.9,842.5,687.8z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-9" onMouseOver={() => {
								  handleMapDotOver("schools", 9);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 9);
								}}>
									<circle className="st0-school" cx="870.3" cy="49.1" r="7.6"/>
									<path className="st1" d="M872.6,47.3c0-1.5-0.9-2.4-2.3-2.4c-1.4,0-2.3,1.1-2.3,2.5c0,1.4,0.9,2.4,2.2,2.4c0.3,0,0.6-0.1,0.9-0.2
										l-1.9,3.8h0.9l2.1-4.2C872.5,48.5,872.6,47.9,872.6,47.3z M871.8,47.3c0,1-0.6,1.7-1.5,1.7c-1,0-1.5-0.8-1.5-1.7
										c0-1,0.6-1.7,1.5-1.7C871.2,45.6,871.8,46.3,871.8,47.3z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-10" onMouseOver={() => {
								  handleMapDotOver("schools", 10);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 10);
								}}>
									<circle className="st0-school" cx="857.2" cy="62.6" r="7.6"/>
									<path className="st1" d="M854.6,66.8v-8.4h-0.9l-1.6,1.4v1l1.6-1.4v7.5H854.6z M862.3,64.6v-3.9c0-1.4-1-2.3-2.3-2.3
										c-1.3,0-2.3,0.9-2.3,2.3v3.9c0,1.4,1,2.3,2.3,2.3C861.3,66.9,862.3,66,862.3,64.6z M861.4,64.5c0,0.9-0.5,1.6-1.5,1.6
										c-0.9,0-1.5-0.7-1.5-1.6v-3.8c0-0.9,0.5-1.6,1.5-1.6c0.9,0,1.5,0.7,1.5,1.6V64.5z"/>
								</g>
								<g className="cursor-pointer" id="schools-legend-11" onMouseOver={() => {
								  handleMapDotOver("schools", 11);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 11);
								}}>
									<circle className="st0-school" cx="500.6" cy="88.5" r="7.6"/>
									<path className="st1" d="M498.7,92.7v-8.4h-0.9l-1.6,1.4v1l1.6-1.4v7.5H498.7z M504.9,92.7v-8.4H504l-1.6,1.4v1l1.6-1.4v7.5H504.9z"
										/>
								</g>
								<g className="cursor-pointer" id="schools-legend-12" onMouseOver={() => {
								  handleMapDotOver("schools", 12);
								}} onMouseOut={() => {
								  handleMapDotOver("schools", 12);
								}}>
									<circle className="st0-school" cx="604.7" cy="282.7" r="7.6"/>
									<polygon className="st1" points="602.1,286.9 602.1,278.5 601.2,278.5 599.6,279.9 599.6,280.8 601.2,279.5 601.2,286.9"/>
									<path id="_x31__00000081606217914870312680000012269690995614418827_" className="st1" d="M609.8,286.9v-0.8h-3.6l2.9-3.8
										c0.5-0.6,0.7-1,0.7-1.7c0-1.4-0.9-2.3-2.3-2.3c-1.4,0-2.3,1-2.3,2.3h0.9c0-1.1,0.7-1.5,1.5-1.5c0.9,0,1.5,0.6,1.5,1.5
										c0,0.5-0.2,0.8-0.5,1.2l-3.3,4.2v0.8H609.8z"/>
								</g>
							</g>
						</g>
					</svg>
				</div>
				<div className="absolute top-0 left-0 w-[21.5vw] h-full bg-[rgba(255,255,255,0.8)]">
					<div className="relative p-[2.63vw] text-[#A98B68] text-[0.95vw]">
						<div className="relative">
							<div className="relative pb-[1.31vw]">
								<div className="flex flex-row items-start transition-all duration-300 cursor-pointer" onClick={() => setCategory("all")}>							
									<h3 className="flex-1 text-[1.25vw] leading-[1.68vw] font-normal">All</h3>
								</div>
							</div>
							{locations.map(({ category, catLabel, markers }, i) => (
							  <Accordion open={open === i + 1} className=" pb-[1.31vw]" key={i}>
								<AccordionHeader
								  className="border-0 py-0"
								  onClick={() => {
									handleOpen(i + 1);
									setCategory(category);
								  }}
								>
									<div className="flex flex-row items-center">
										{ category === "shopping" && <img src={PurpleDot} className="flex-none w-[5.856%]"></img> }
										{ category === "dining" && <img src={OrangeDot} className="flex-none w-[5.856%]"></img> }
										{ category === "recreation" && <img src={GreenDot} className="flex-none w-[5.856%]"></img> }
										{ category === "schools" && <img src={BlueDot} className="flex-none w-[5.856%]"></img> }
										<h3 className="flex-1 pl-[0.26vw] text-[1.25vw] text-[#A98B68] font-normal leading-[1.68vw]">{catLabel}</h3>
									</div>
								</AccordionHeader>
								<AccordionBody className="py-0 pt-[0.63vw]">

									{markers.map(({ title }, j) => (
										<div key={j} className="flex flex-row items-start cursor-pointer text-[0.95vw]" onClick={() => handleMapDotClick(category, (j+1))}>	
											<div className="flex-none w-[5.856%] text-center">{j + 1}.</div>
											<div className="flex-1 pl-[0.26vw]">{title}</div>
										</div>
									))}
								</AccordionBody>
							  </Accordion>
							))}							
						</div>
					</div>
				</div>
				{locations.map(({ category, catLabel, markers }, i) => (
				  <div key={i}>
						{markers.map(({ title, boxWidth, position, boxPosition, anglePosition }, j) => (
							<div key={j} className={`map-dots absolute ${position}`} id={category+"-dot-"+(j+1)}>
								<div
									className={`absolute ${boxWidth} bg-white p-[0.53vw] transition-all duration-700 ${boxPosition} left-[50%] translate-x-[-50%] opacity-100 translate-y-[-100%] leading-[0.92vw] text-center text-[0.92vw]`}
								  >
									<div className={`absolute bg-white w-[1.05vw] h-[1.05vw] rotate-45 left-[50%] translate-x-[-50%] ${anglePosition} z-[-11]`}></div>
									<div className="z-[99]">{title}</div>
								</div>
							</div>
						))}
				  </div>
				))}
			</div>
		</div>
		<div className="relative pb-[50px]">
			<div className="lg:hidden relative p-[25px] text-[#A98B68]">
				<div className="relative pb-[1.31vw]">
					<div className="flex flex-row items-start transition-all duration-300 cursor-pointer" onClick={() => setCategory("all")}>
						<h3 className="flex-1 font-normal">All</h3>
					</div>
				</div>
				{locations.map(({ category, catLabel, markers }, i) => (
				  <Accordion open={open === i + 1} className="relative pb-[1.31vw]" key={i}>
					<AccordionHeader
					  className="relative border-0 py-0"
					  onClick={() => {
						handleOpen(i + 1);
						setCategory(category);
					  }}
					>
						<div className="relative flex flex-row items-center">
							{ category === "shopping" && <img src={PurpleDot} className="flex-none w-[20px]"></img> }
							{ category === "dining" && <img src={OrangeDot} className="flex-none w-[20px]"></img> }
							{ category === "recreation" && <img src={GreenDot} className="flex-none w-[20px]"></img> }
							{ category === "schools" && <img src={BlueDot} className="flex-none w-[20px]"></img> }
							<h3 className="flex-1 pl-[5px] text-[#A98B68] font-normal">{catLabel}</h3>
						</div>
					</AccordionHeader>
					<AccordionBody className="py-0 pt-3 text-lg">

						{markers.map(({ title }, j) => (
							<div key={j} className="flex flex-row items-start cursor-pointer">
								<div className="flex-none w-[20px] text-center">{j + 1}.</div>
								<div className="flex-1 pl-[5px]">{title}</div>
							</div>
						))}
					</AccordionBody>
				  </Accordion>
				))}				
			</div>
		</div>
	</div>
  );
};

export default Map;
